function uniqueLayersBySourceName(layerArr) {
    var names = {};
    var result = [];
    for (var i = 0; i < layerArr.length; i++) {
        var name = layerArr[i].source.name;
        if (!names[name]) {
            names[name] = true;
            result.push(layerArr[i]);
        }
    }
    return result;
}
(function() {
    app.beginUndoGroup("AL_DuplicateReplace");
    try {
        var comp = app.project.activeItem;
        var selectedLayers = comp.selectedLayers
        var keyState = ScriptUI.environment.keyboardState;
        // cmd + クリックなら再帰
        if (keyState.ctrlKey || keyState.metaKey) {
            function duprepAlt(comp) {
                var layers = comp.layers
                var compLayers = []
                for (var i = 1; i <= layers.length; i++) {
                    var selectedLayer = layers[i]
                    if (selectedLayer.source instanceof CompItem) {
                        compLayers.push(selectedLayer)
                    }
                }
                var nonKaburriCompLayers = uniqueLayersBySourceName(compLayers)
                var dupLayers = []
                for (var i = 0; i < nonKaburriCompLayers.length; i++) {
                    var dup = nonKaburriCompLayers[i].source.duplicate()
                    dupLayers.push(dup)
                }
                var compLayerDupNameDict = {}
                for (var i = 0; i < nonKaburriCompLayers.length; i++) {
                    compLayerDupNameDict[nonKaburriCompLayers[i].source.name] = dupLayers[i]
                }
                for (var i = 0; i < compLayers.length; i++) {
                    compLayers[i].replaceSource(compLayerDupNameDict[compLayers[i].source.name], false)
                    duprepAlt(compLayers[i].source)
                }
            }

            var compLayers = []
            for (var i = 0; i < selectedLayers.length; i++) {
                var selectedLayer = selectedLayers[i]
                if (selectedLayer.source instanceof CompItem) {
                    compLayers.push(selectedLayer)
                }
            }
            var nonKaburriCompLayers = uniqueLayersBySourceName(compLayers)
            var dupLayers = []
            for (var i = 0; i < nonKaburriCompLayers.length; i++) {
                var dup = nonKaburriCompLayers[i].source.duplicate()
                dupLayers.push(dup)
            }
            var compLayerDupNameDict = {}
            for (var i = 0; i < nonKaburriCompLayers.length; i++) {
                compLayerDupNameDict[nonKaburriCompLayers[i].source.name] = dupLayers[i]
            }
            for (var i = 0; i < compLayers.length; i++) {
                compLayers[i].replaceSource(compLayerDupNameDict[compLayers[i].source.name], false)
                duprepAlt(compLayers[i].source)
            }
        } else {
            // 普通のクリックなら元が同じコンポのレイヤーを一度だけ複製して使い回す
            if (!keyState.altKey) {
                var compLayers = []
                for (var i = 0; i < selectedLayers.length; i++) {
                    var selectedLayer = selectedLayers[i]
                    if (selectedLayer.source instanceof CompItem) {
                        compLayers.push(selectedLayer)
                    }
                }
                var nonKaburriCompLayers = uniqueLayersBySourceName(compLayers)
                var dupLayers = []
                for (var i = 0; i < nonKaburriCompLayers.length; i++) {
                    var dup = nonKaburriCompLayers[i].source.duplicate()
                    dupLayers.push(dup)
                }
                var compLayerDupNameDict = {}
                for (var i = 0; i < nonKaburriCompLayers.length; i++) {
                    compLayerDupNameDict[nonKaburriCompLayers[i].source.name] = dupLayers[i]
                }
                for (var i = 0; i < compLayers.length; i++) {
                    compLayers[i].replaceSource(compLayerDupNameDict[compLayers[i].source.name], false)
                }
            } else {
                // Alt + クリックなら使い回さない
                for (var i = 0; i < selectedLayers.length; i++) {
                    var selectedLayer = selectedLayers[i]
                    if (selectedLayer.source instanceof CompItem) {
                        var dup = selectedLayer.source.duplicate()
                        selectedLayer.replaceSource(dup, false)
                    }
                }
            }
        }
    } catch (e) {
        alert(e.message + e.line)
    }
    app.endUndoGroup();
})()