(function () {
  app.beginUndoGroup("AL_All3D");
  try {
    var comp = app.project.activeItem
    var selectedLayers = comp.selectedLayers
    for (var i = 0; i < selectedLayers.length; i++) {
      var selectedLayer = selectedLayers[i]
      selectedLayer.threeDLayer = true
      if (selectedLayer.source instanceof CompItem) {
        allTo3D(selectedLayer.source)
      }
    }

    function allTo3D(comp) {
      var layers = comp.layers
      for (var i = 1; i <= layers.length; i++) {
        var layer = layers[i]
        if (!layer.adjustmentLayer) {
          layer.threeDLayer = true
        }
        if (layer.source instanceof CompItem) {
          allTo3D(layer.source)
        }
      }
    }
  } catch (e) {
    alert(e.message + e.line)
  }
  app.endUndoGroup();
})()